/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.MessageUtils;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColonyServerMessage
implements IMessage {
    private ResourceKey<Level> dimensionId;
    private int colonyId;

    public AbstractColonyServerMessage() {
    }

    public AbstractColonyServerMessage(IColony colony) {
        this(colony.getDimension(), colony.getID());
    }

    public AbstractColonyServerMessage(ResourceKey<Level> dimensionId, int colonyId) {
        this.dimensionId = dimensionId;
        this.colonyId = colonyId;
    }

    @Nullable
    public Action permissionNeeded() {
        return Action.MANAGE_HUTS;
    }

    public boolean ownerOnly() {
        return false;
    }

    protected abstract void onExecute(NetworkEvent.Context var1, boolean var2, IColony var3);

    protected abstract void toBytesOverride(FriendlyByteBuf var1);

    protected void toBytesAbstractOverride(FriendlyByteBuf buf) {
    }

    @Override
    public final void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.dimensionId.m_135782_().toString());
        buf.writeInt(this.colonyId);
        this.toBytesAbstractOverride(buf);
        this.toBytesOverride(buf);
    }

    protected abstract void fromBytesOverride(FriendlyByteBuf var1);

    protected void fromBytesAbstractOverride(FriendlyByteBuf buf) {
    }

    @Override
    public final void fromBytes(FriendlyByteBuf buf) {
        this.dimensionId = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.colonyId = buf.readInt();
        this.fromBytesAbstractOverride(buf);
        this.fromBytesOverride(buf);
    }

    @Override
    public final LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public final void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyId, this.dimensionId);
        if (colony != null) {
            if (!this.ownerOnly() && this.permissionNeeded() != null && !colony.getPermissions().hasPermission((Player)player, this.permissionNeeded())) {
                if (player == null) {
                    return;
                }
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.permission.deny", new Object[0]).sendTo(new Player[]{player});
                return;
            }
            if (this.ownerOnly() && (player == null || colony.getPermissions().getOwner().equals(player.m_142081_()))) {
                if (player == null) {
                    return;
                }
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.permission.deny", new Object[0]).sendTo(new Player[]{player});
                return;
            }
            this.onExecute(ctxIn, isLogicalServer, colony);
        } else {
            MessageUtils.format("com.minecolonies.coremod.gui.nocolony", this.getClass().getSimpleName()).sendTo(new Player[]{player});
        }
    }
}

